const nodemailer = require("nodemailer");

  // Only needed if you don't have a real mail account for testing
  const transporter = nodemailer.createTransport({
    host: process.env.EMAIL_HOST,
    secure: true,
    port: 465,
    auth: {
      user: process.env.EMAIL_USER,
      pass: process.env.EMAIL_PASS,
    }
  });

async function sendEmail(
  template,
  send_to,
  sent_from,
  reply_to,
  name,
  Code,
  subject
) {


  // send mail with defined transport object
  const options = {
    from:  `"Clikkle "<${sent_from}>` , // sender address
    to: send_to, // list of receivers
    subject: subject, // Subject line
    text: reply_to, // plain text body
    // html: `<b>${template}</b>
    //       <p>Name : ${name}</p>
    //       <p>Code : ${Code}</p>`, // html body

    priority: 'high',
    html: `<div><u></u>
    <div>
        <div>
            <div>
                <img src="https://cdn.clikkle.com/images/clikkle/logo/2023/clikkle-text.png" alt="Clikkle Logo Here" style="height:50px" class="CToWUd" data-bit="iit">
                <h2>Clikkle</h2>
            </div>
            <div>
                <h1>Email Verification</h1>
                <p style="font-size:14px">
                    Hello ${name}, It seems you are registering at <a href="http://clikkle.com" rel="noreferrer" target="_blank" data-saferedirecturl="https://www.google.com/url?q=http://clikkle.com&amp;source=gmail&amp;ust=1711487861251000&amp;usg=AOvVaw2ZvlOi0e1-J-aLwt4ONlLK">clikkle.com</a> and trying to verify
                    your email address.
                </p>
                <p style="font-size:14px">
                    Here is the verification code. Please copy it and verify your email.
                </p>
                <h3>Below is your one time passcode</h3>
                <h3>${Code}</h3>
                <p style="font-size:14px">
                    If you did'nt request this, you can ignore this email or let us know.
                </p>
                <h3>Thanks!</h3><div class="yj6qo"></div><div class="adL">
            </div></div><div class="adL">
        </div></div><div class="adL">
    </div></div><div class="adL">
</div>
</div>`
  }

  let info = transporter.sendMail(options, function (err, info) {
    if (err) {
      console.log('err', err);
      return err
    } else {
      // console.log("info", info);
      return info
      // return true
    }
  });

  return true
}


async function registerEmailVerification({
  send_to,
  sent_from,
  reply_to,
  name,
  otp,
}){

  let template =  `<div style="font-family:Arial,sans-serif;margin:8px;padding:0;">
  <div >
  
      <table  align="center" cellpadding="0" border="0" cellspacing="0" style="max-width:600px;width:100%;border:1px solid #edece9;" >
          <tbody>
              <tr style="border-bottom: 1px solid #808282;  ">
                  <td align="center" style="padding:8px 0">
                      <div>
                          <img src="https://cdn.clikkle.com/images/clikkle/logo/2023/clikkle-text.png"
                              alt="Clikkle Logo Here" style="height:50px">
                      </div>
                  </td> 
              </tr>  
              <tr>  
              <td >  
                   <div  style="background: #bdbfbf; width:100%; height :1px"></div>  
              </td>   
              </tr>  
              <tr>
                  <td style="padding:20px; text-align: center;">
                      <h2 style="color:#333333; ">Email Verification </h2>
                      <p>
                         Hello ${name}, it seems you are registering at clikkle.com and trying  <br/> to verify your email address
                      </p>
                      <p>
                         Here is the verification code to access your account. 
                      </p>

                      <div style="margin-top: 8px ; "> 

                          <p style="color:#333333; padding: 8px 20px; font-size: 2rem; "> C-${otp}</p>

                      </div>
                      <p>
                          Please enter this code to verify your Identity and sign in.
                      </p>
                      <p>
                           <b>Thanks!</b>
                      </p>
                      <p>
                          
                          <a href="mailto:contact@clikkle.com" rel="noreferrer"
                              target="_blank">Having trouble viewing this message ?</a>.
                      </p>
                  </td>
              </tr>

              <tr>
                  <td style=" padding:10px 0;text-align:center ; background-color: #bdbfbf;">
                      Copyright  2024 Clikkle Technologies  |
                      <a href="https://clikkle.com" style="text-decoration:none" target="_blank">clikkle.com</a>
                  </td>
              </tr>
          </tbody>
      </table>
  </div>
</div>`;

let options = {
  from: `"Clikkle "<${sent_from}>`, // sender address
  to: send_to, // list of receivers
  subject: "Login Access Code - Verify", // Subject line
  text: reply_to, // plain text body
  priority: 'high',
  html: template
}


let info = transporter.sendMail(options, function (err, info) {
  if (err) {
    console.log('err', err);
    return  {err , success:  false  }
  } else {
    // console.log("info", info);
    return  {info , success:  true  }
    // return true
  }
});
console.log("info", info);
}


async function forgetUserNameEmail({
  send_to,
  sent_from,
  reply_to,
  name,
  username,
  email
}){

  let template =  `<div style="font-family:Arial,sans-serif;margin:8px;padding:0;">
  <div >
  <table  align="center" cellpadding="0" border="0" cellspacing="0" style="max-width:600px;width:100%;border:1px solid #edece9;" >
          <tbody>
              <tr style="border-bottom: 1px solid #808282;  ">
                  <td align="center" style="padding:8px 0">
                      <div>
                          <img src="https://cdn.clikkle.com/images/clikkle/logo/2023/clikkle-text.png"
                              alt="Clikkle Logo Here" style="height:50px" class="CToWUd" data-bit="iit">
                      </div>
                  </td> 
              </tr> 
              <tr>  
              <td >  
                   <div  style="background: #bdbfbf; width:100%; height :1px"></div>  
              </td>   
              </tr>   
              <tr>
                  <td style="padding:20px; text-align: center;">
                      <h2 style="color:#333333; ">Forgot Clikkmail </h2>
                      <p>
                         Hello ${name}, we received a request that  you have forgot your Clikkmail username to <br/> your Clikkle account.
                      </p>
                      <p>
                         Here is the your account information . 
                      </p>

                      <div style="margin-top: 8px ; color:#333333;"> 
                       <p style=" padding: 8px; font-size: 1.5rem; "> username - <b> ${username}</b></p>
                      </div>
                      <div > 
                       <p style="color:#333333; padding: 8px; font-size: 1.2rem; "> Clikkmail - <b> ${email}</b></p>
                      </div>
                      <p>
                          please use these credentials to sign in
                      </p>
                      <p>
                           <b>Thanks!</b>
                      </p>
                      <p>
                          <a href="mailto:contact@clikkle.com" rel="noreferrer"
                              target="_blank">Having trouble viewing this message ?</a>.
                      </p>
                  </td>
              </tr>

              <tr>
                  <td style=" padding:10px 0;text-align:center ; background-color: #bdbfbf;">
                      Copyright  2024 Clikkle Technologies  |
                      <a href="https://clikkle.com" style="text-decoration:none" target="_blank"
                          data-saferedirecturl="https://www.google.com/url?q=https://clikkle.com&amp;source=gmail&amp;ust=1721930643524000&amp;usg=AOvVaw3sL89iLmMl8X7TeR_WLjUg">clikkle.com</a>
                  </td>
              </tr>
          </tbody>
      </table>
  </div>
</div>`;

let options = {
  from: `"Clikkle "<${sent_from}>`, // sender address
  to: send_to, // list of receivers
  subject: "Forget Clikkmail", // Subject line
  text: reply_to, // plain text body
  priority: 'high',
  html: template
}


let info = transporter.sendMail(options, function (err, info) {
  if (err) {
    console.log('err', err);
    return  {err , success:  false  }
  } else {
    // console.log("info", info);
    return  {info , success:  true  }
    // return true
  }
});
}


async function forgetPasswordEmail({
  send_to,
  sent_from,
  reply_to,
  name,
  otp,
}){

  let  template =  `<div style="font-family:Arial,sans-serif;margin:8px;padding:0;">
  <div >
  <table  align="center" cellpadding="0" border="0" cellspacing="0" style="max-width:600px;width:100%;border:1px solid #edece9;" >
          <tbody>
              <tr style="border-bottom: 1px solid #808282;  ">
                  <td align="center" style="padding:8px 0">
                      <div>
                          <img src="https://cdn.clikkle.com/images/clikkle/logo/2023/clikkle-text.png"
                              alt="Clikkle Logo Here" style="height:50px" class="CToWUd" data-bit="iit">

                      </div>
                  </td>
              </tr> 
              <tr>  
              <td >  
                   <div  style="background: #bdbfbf; width:100%; height :1px"></div>  
              </td>   
              </tr>             
              <tr>
                  <td style="padding:20px; text-align: center;">
                      <h2 style="color:#333333; ">Forgot Password</h2>
                      <p>
                         Hello ${name}, we received a request to change the password to <br/> your Clikkle account.
                      </p>
                      <p>
                          you can reset your password by copying <br/>the code below  
                      </p>

                      <div style="background-color:#bdbfbf; margin-left: auto; margin-right: auto; width: fit-content;"> 
                          <p style="color:#333333; padding: 5px 20px; font-size: 2rem; ">${otp}</p>

                      </div>
                      <p>
                          please enter this code to reset your password
                      </p>
                      <p>
                          This code expires in  <b> 10 minute</b>
                      </p>
                      <p> 
                          <a href="mailto:contact@clikkle.com" rel="noreferrer"
                              target="_blank">Having trouble viewing this message ?</a>.
                      </p>
                  </td>
              </tr>

              <tr>
                  <td style=" padding:10px 0;text-align:center ; background-color: #bdbfbf;">
                      Copyright  2024 Clikkle Technologies  |
                      <a href="https://clikkle.com" style="text-decoration:none" target="_blank"
                          data-saferedirecturl="https://www.google.com/url?q=https://clikkle.com&amp;source=gmail&amp;ust=1721930643524000&amp;usg=AOvVaw3sL89iLmMl8X7TeR_WLjUg">clikkle.com</a>
                  </td>
              </tr>
          </tbody>
      </table>
  </div>
</div>`

let options = {
  from: `"Clikkle "<${sent_from}>`, // sender address
  to: send_to, // list of receivers
  subject: "Forget Password - Reset", // Subject line
  text: reply_to, // plain text body
  priority: 'high',
  html: template
}


let info = transporter.sendMail(options, function (err, info) {
  if (err) {
    console.log('err', err);
    return  {err , success:  false  }
  } else {
    // console.log("info", info);
    return  {info , success:  true  }
    // return true
  }
});

return true ;

}



module.exports = { sendEmail , registerEmailVerification ,forgetPasswordEmail , forgetUserNameEmail };
